<?php
 class WP2Static_BunnyCDN extends WP2Static_SitePublisher { public function __construct() { $this->loadSettings( 'bunnycdn' ); $this->api_base = 'https://storage.bunnycdn.com'; $this->previous_hashes_path = $this->settings['wp_uploads_path'] . '/WP2STATIC-BUNNYCDN-PREVIOUS-HASHES.txt'; if ( defined( 'WP_CLI' ) ) { return; } switch ( $_POST['ajax_action'] ) { case 'bunnycdn_prepare_export': $this->bootstrap(); $this->loadArchive(); $this->prepareDeploy( true ); break; case 'bunnycdn_transfer_files': $this->bootstrap(); $this->loadArchive(); $this->upload_files(); break; case 'bunnycdn_purge_cache': $this->purge_all_cache(); break; case 'test_bunny': $this->test_deploy(); break; } } public function upload_files() { $this->files_remaining = $this->getRemainingItemsCount(); if ( $this->files_remaining < 0 ) { echo 'ERROR'; die(); } $this->initiateProgressIndicator(); $batch_size = $this->settings['deployBatchSize']; if ( $batch_size > $this->files_remaining ) { $batch_size = $this->files_remaining; } $lines = $this->getItemsToDeploy( $batch_size ); $this->openPreviousHashesFile(); foreach ( $lines as $line ) { list($this->local_file, $this->target_path) = explode( ',', $line ); $this->local_file = $this->archive->path . $this->local_file; if ( ! is_file( $this->local_file ) ) { continue; } if ( isset( $this->settings['bunnycdnRemotePath'] ) ) { $this->target_path = $this->settings['bunnycdnRemotePath'] . '/' . $this->target_path; } $this->local_file_contents = file_get_contents( $this->local_file ); if ( isset( $this->file_paths_and_hashes[ $this->target_path ] ) ) { $prev = $this->file_paths_and_hashes[ $this->target_path ]; $current = crc32( $this->local_file_contents ); if ( $prev != $current ) { if ( $this->fileExistsInBunnyCDN() ) { $this->updateFileInBunnyCDN(); } else { $this->createFileInBunnyCDN(); } $this->recordFilePathAndHashInMemory( $this->target_path, $this->local_file_contents ); } } else { if ( $this->fileExistsInBunnyCDN() ) { $this->updateFileInBunnyCDN(); } else { $this->createFileInBunnyCDN(); } $this->recordFilePathAndHashInMemory( $this->target_path, $this->local_file_contents ); } $this->updateProgress(); } $this->writeFilePathAndHashesToFile(); $this->pauseBetweenAPICalls(); if ( $this->uploadsCompleted() ) { $this->finalizeDeployment(); } } public function purge_all_cache() { try { $endpoint = 'https://bunnycdn.com/api/pullzone/' . $this->settings['bunnycdnPullZoneID'] . '/purgeCache'; $ch = curl_init(); curl_setopt( $ch, CURLOPT_CUSTOMREQUEST, 'POST' ); curl_setopt( $ch, CURLOPT_URL, $endpoint ); curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 ); curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, 0 ); curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, 0 ); curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 0 ); curl_setopt( $ch, CURLOPT_POST, 1 ); curl_setopt( $ch, CURLOPT_HTTPHEADER, array( 'Content-Type: application/json', 'Content-Length: 0', 'AccessKey: ' . $this->settings['bunnycdnPullZoneAccessKey'], ) ); $output = curl_exec( $ch ); $status_code = curl_getinfo( $ch, CURLINFO_HTTP_CODE ); curl_close( $ch ); $good_response_codes = array( '200', '201' ); if ( ! in_array( $status_code, $good_response_codes ) ) { require_once dirname( __FILE__ ) . '/../WP2Static/WsLog.php'; WsLog::l( 'BAD RESPONSE STATUS (' . $status_code . '): ' ); echo 'FAIL'; throw new Exception( 'BunnyCDN API bad response status' ); } if ( ! defined( 'WP_CLI' ) ) { echo 'SUCCESS'; } } catch ( Exception $e ) { WsLog::l( 'BUNNYCDN EXPORT: error encountered' ); WsLog::l( $e ); throw new Exception( $e ); } } public function test_deploy() { try { $remote_path = $this->api_base . '/' . $this->settings['bunnycdnStorageZoneName'] . '/tmpFile'; $ch = curl_init(); curl_setopt( $ch, CURLOPT_CUSTOMREQUEST, 'PUT' ); curl_setopt( $ch, CURLOPT_URL, $remote_path ); curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 ); curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, 0 ); curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, 0 ); curl_setopt( $ch, CURLOPT_HEADER, 0 ); curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1 ); curl_setopt( $ch, CURLOPT_POST, 1 ); curl_setopt( $ch, CURLOPT_HTTPHEADER, array( 'AccessKey: ' . $this->settings['bunnycdnStorageZoneAccessKey'], ) ); $post_options = array( 'body' => 'Test WP2Static connectivity', ); curl_setopt( $ch, CURLOPT_POSTFIELDS, $post_options ); $output = curl_exec( $ch ); $status_code = curl_getinfo( $ch, CURLINFO_HTTP_CODE ); curl_close( $ch ); $good_response_codes = array( '200', '201', '301', '302', '304' ); if ( ! in_array( $status_code, $good_response_codes ) ) { require_once dirname( __FILE__ ) . '/../WP2Static/WsLog.php'; WsLog::l( 'BAD RESPONSE STATUS (' . $status_code . '): ' ); throw new Exception( 'BunnyCDN API bad response status' ); } } catch ( Exception $e ) { require_once dirname( __FILE__ ) . '/../WP2Static/WsLog.php'; WsLog::l( 'BUNNYCDN EXPORT: error encountered' ); WsLog::l( $e ); throw new Exception( $e ); } if ( ! defined( 'WP_CLI' ) ) { echo 'SUCCESS'; } } public function fileExistsInBunnyCDN() { require_once dirname( __FILE__ ) . '/../WP2Static/Request.php'; $this->client = new WP2Static_Request(); return false; } public function createFileInBunnyCDN() { try { $remote_path = $this->api_base . '/' . $this->settings['bunnycdnStorageZoneName'] . '/' . $this->target_path; $headers = array( 'AccessKey: ' . $this->settings['bunnycdnStorageZoneAccessKey'], ); $this->client->putWithFileStreamAndHeaders( $remote_path, $this->local_file, $headers ); $this->checkForValidResponses( $this->client->status_code, array( '200', '201', '301', '302', '304' ) ); } catch ( Exception $e ) { $this->handleException( $e ); } } } $bunny = new WP2Static_BunnyCDN(); 